import React, { FC, Fragment } from 'react';
import { Card, Col, OverlayTrigger, Row, Tooltip } from 'react-bootstrap';
import PageHeader from '../../../layout/Header/pageheader';



interface TypiconIconsProps {}

const TypiconIcons: FC<TypiconIconsProps> = () => (
  <Fragment>
  <PageHeader  title="Typicons" />
  <Row>
    <Col md={12}>
      <Card>
        <Card.Header>
          <Card.Title>Typicons icons</Card.Title>
        </Card.Header>
        <Card.Body>
          <Row>
            <Col lg={12} sm={12} mb={4}>
              <p className="mb-2">Simply beautiful open source icons. For more info <a
                  className="fs-16 text-primary font-weight-bold"
                  href="https://www.s-ings.com/typicons/" target="_blank" rel="noreferrer">click
                  here</a>.</p>
              <p><code>&lt;i className="typcn typcn-ICON_NAME"&gt;&lt;/i&gt;</code></p>
            </Col>
            <Col lg={12} sm={12}>
              <div className="icons-list-wrap">
                <ul className="icons-list">
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-chart-pie-outline</Tooltip>}><i className="typcn typcn-chart-pie-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-chart-pie-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-chart-pie</Tooltip>}><i className="typcn typcn-chart-pie"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-chart-pie"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-chevron-left-outline</Tooltip>}><i className="typcn typcn-chevron-left-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-chevron-left-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-chevron-left</Tooltip>}><i className="typcn typcn-chevron-left"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-chevron-left"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-chevron-right-out</Tooltip>}><i className="typcn typcn-chevron-right-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-chevron-right-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-chevron-right</Tooltip>}><i className="typcn typcn-chevron-right"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-chevron-right"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-clipboard</Tooltip>}><i className="typcn typcn-clipboard"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-clipboard"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-cloud-storage</Tooltip>}><i className="typcn typcn-cloud-storage"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-cloud-storage"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-cloud-storage-out</Tooltip>}><i className="typcn typcn-cloud-storage-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-cloud-storage-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-code-outline</Tooltip>}><i className="typcn typcn-code-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-code-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-code</Tooltip>}><i className="typcn typcn-code"
                      data-bs-toggle="tooltip" title="typcn typcn-code"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-coffee</Tooltip>}><i className="typcn typcn-coffee"
                      data-bs-toggle="tooltip" title="typcn typcn-coffee"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-cog-outline</Tooltip>}><i className="typcn typcn-cog-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-cog-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-cog</Tooltip>}><i className="typcn typcn-cog"
                      data-bs-toggle="tooltip" title="typcn typcn-cog"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-compass</Tooltip>}><i className="typcn typcn-compass"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-compass"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-contacts</Tooltip>}><i className="typcn typcn-contacts"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-contacts"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-credit-card</Tooltip>}><i className="typcn typcn-credit-card"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-credit-card"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-css3</Tooltip>}><i className="typcn typcn-css3"
                      data-bs-toggle="tooltip" title="typcn typcn-css3"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-database</Tooltip>}><i className="typcn typcn-database"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-database"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-delete-outline</Tooltip>}><i className="typcn typcn-delete-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-delete-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-delete</Tooltip>}><i className="typcn typcn-delete"
                      data-bs-toggle="tooltip" title="typcn typcn-delete"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-device-desktop</Tooltip>}><i className="typcn typcn-device-desktop"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-device-desktop"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-device-laptop</Tooltip>}><i className="typcn typcn-device-laptop"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-device-laptop"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-device-phone</Tooltip>}><i className="typcn typcn-device-phone"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-device-phone"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-device-tablet</Tooltip>}><i className="typcn typcn-device-tablet"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-device-tablet"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-directions</Tooltip>}><i className="typcn typcn-directions"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-directions"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-divide-outline</Tooltip>}><i className="typcn typcn-divide-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-divide-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-divide</Tooltip>}><i className="typcn typcn-divide"
                      data-bs-toggle="tooltip" title="typcn typcn-divide"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-document-add</Tooltip>}><i className="typcn typcn-document-add"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-document-add"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-document-delete</Tooltip>}><i className="typcn typcn-document-delete"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-document-delete"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-document-text</Tooltip>}><i className="typcn typcn-document-text"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-document-text"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-document</Tooltip>}><i className="typcn typcn-document"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-document"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-download-outline</Tooltip>}><i className="typcn typcn-download-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-download-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-download</Tooltip>}><i className="typcn typcn-download"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-download"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-dropbox</Tooltip>}><i className="typcn typcn-dropbox"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-dropbox"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-edit</Tooltip>}><i className="typcn typcn-edit"
                      data-bs-toggle="tooltip" title="typcn typcn-edit"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-eject-outline</Tooltip>}><i className="typcn typcn-eject-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-eject-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-eject</Tooltip>}><i className="typcn typcn-eject"
                      data-bs-toggle="tooltip" title="typcn typcn-eject"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-equals-outline</Tooltip>}><i className="typcn typcn-equals-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-equals-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-equals</Tooltip>}><i className="typcn typcn-equals"
                      data-bs-toggle="tooltip" title="typcn typcn-equals"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-export-outline</Tooltip>}><i className="typcn typcn-export-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-export-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-export</Tooltip>}><i className="typcn typcn-export"
                      data-bs-toggle="tooltip" title="typcn typcn-export"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-eye-outline</Tooltip>}><i className="typcn typcn-eye-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-eye-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-eye</Tooltip>}><i className="typcn typcn-eye"
                      data-bs-toggle="tooltip" title="typcn typcn-eye"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-feather</Tooltip>}><i className="typcn typcn-feather"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-feather"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-film</Tooltip>}><i className="typcn typcn-film"
                      data-bs-toggle="tooltip" title="typcn typcn-film"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-filter</Tooltip>}><i className="typcn typcn-filter"
                      data-bs-toggle="tooltip" title="typcn typcn-filter"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-flag-outline</Tooltip>}><i className="typcn typcn-flag-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-flag-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-flag</Tooltip>}><i className="typcn typcn-flag"
                      data-bs-toggle="tooltip" title="typcn typcn-flag"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-flash-outline</Tooltip>}><i className="typcn typcn-flash-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-flash-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-flash</Tooltip>}><i className="typcn typcn-flash"
                      data-bs-toggle="tooltip" title="typcn typcn-flash"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-flow-children</Tooltip>}><i className="typcn typcn-flow-children"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-flow-children"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-flow-merge</Tooltip>}><i className="typcn typcn-flow-merge"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-flow-merge"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-flow-parallel</Tooltip>}><i className="typcn typcn-flow-parallel"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-flow-parallel"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-flow-switch</Tooltip>}><i className="typcn typcn-flow-switch"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-flow-switch"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-folder-add</Tooltip>}><i className="typcn typcn-folder-add"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-folder-add"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-folder-delete</Tooltip>}><i className="typcn typcn-folder-delete"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-folder-delete"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-folder-open</Tooltip>}><i className="typcn typcn-folder-open"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-folder-open"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-folder</Tooltip>}><i className="typcn typcn-folder"
                      data-bs-toggle="tooltip" title="typcn typcn-folder"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-gift</Tooltip>}><i className="typcn typcn-gift"
                      data-bs-toggle="tooltip" title="typcn typcn-gift"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-globe-outline</Tooltip>}><i className="typcn typcn-globe-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-globe-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-globe</Tooltip>}><i className="typcn typcn-globe"
                      data-bs-toggle="tooltip" title="typcn typcn-globe"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-group-outline</Tooltip>}><i className="typcn typcn-group-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-group-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-group</Tooltip>}><i className="typcn typcn-group"
                      data-bs-toggle="tooltip" title="typcn typcn-group"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-headphones</Tooltip>}><i className="typcn typcn-headphones"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-headphones"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-heart-full-outline</Tooltip>}><i className="typcn typcn-heart-full-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-heart-full-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-heart-half-outline</Tooltip>}><i className="typcn typcn-heart-half-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-heart-half-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-heart-outline</Tooltip>}><i className="typcn typcn-heart-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-heart-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-heart</Tooltip>}><i className="typcn typcn-heart"
                      data-bs-toggle="tooltip" title="typcn typcn-heart"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-home-outline</Tooltip>}><i className="typcn typcn-home-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-home-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-home</Tooltip>}><i className="typcn typcn-home"
                      data-bs-toggle="tooltip" title="typcn typcn-home"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-html5</Tooltip>}><i className="typcn typcn-html5"
                      data-bs-toggle="tooltip" title="typcn typcn-html5"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-image-outline</Tooltip>}><i className="typcn typcn-image-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-image-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-image</Tooltip>}><i className="typcn typcn-image"
                      data-bs-toggle="tooltip" title="typcn typcn-image"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-infinity-outline</Tooltip>}><i className="typcn typcn-infinity-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-infinity-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-info-large-outline</Tooltip>}><i className="typcn typcn-info-large-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-info-large-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-info-large</Tooltip>}><i className="typcn typcn-info-large"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-info-large"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-info-outline</Tooltip>}><i className="typcn typcn-info-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-info-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-info</Tooltip>}><i className="typcn typcn-info"
                      data-bs-toggle="tooltip" title="typcn typcn-info"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-input-checked-out</Tooltip>}><i className="typcn typcn-input-checked-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-input-checked-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-input-checked</Tooltip>}><i className="typcn typcn-input-checked"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-input-checked"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-key-outline</Tooltip>}><i className="typcn typcn-key-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-key-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-key</Tooltip>}><i className="typcn typcn-key"
                      data-bs-toggle="tooltip" title="typcn typcn-key"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-keyboard</Tooltip>}><i className="typcn typcn-keyboard"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-keyboard"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-leaf</Tooltip>}><i className="typcn typcn-leaf"
                      data-bs-toggle="tooltip" title="typcn typcn-leaf"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-lightbulb</Tooltip>}><i className="typcn typcn-lightbulb"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-lightbulb"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-link-outline</Tooltip>}><i className="typcn typcn-link-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-link-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-link</Tooltip>}><i className="typcn typcn-link"
                      data-bs-toggle="tooltip" title="typcn typcn-link"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-location-arrow-ou</Tooltip>}><i className="typcn typcn-location-arrow-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-location-arrow-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-location-arrow</Tooltip>}><i className="typcn typcn-location-arrow"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-location-arrow"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-location-outline</Tooltip>}><i className="typcn typcn-location-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-location-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-location</Tooltip>}><i className="typcn typcn-location"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-location"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-lock-closed-outline</Tooltip>}><i className="typcn typcn-lock-closed-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-lock-closed-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-lock-closed</Tooltip>}><i className="typcn typcn-lock-closed"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-lock-closed"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-lock-open-outline</Tooltip>}><i className="typcn typcn-lock-open-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-lock-open-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-lock-open</Tooltip>}><i className="typcn typcn-lock-open"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-lock-open"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-mail</Tooltip>}><i className="typcn typcn-mail"
                      data-bs-toggle="tooltip" title="typcn typcn-mail"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-map</Tooltip>}><i className="typcn typcn-map"
                      data-bs-toggle="tooltip" title="typcn typcn-map"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-eject-outline</Tooltip>}><i className="typcn typcn-media-eject-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-eject-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-eject</Tooltip>}><i className="typcn typcn-media-eject"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-eject"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-fast-forward</Tooltip>}><i className="typcn typcn-media-fast-forward-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-fast-forward-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-fast-forward</Tooltip>}><i className="typcn typcn-media-fast-forward"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-fast-forward"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-pause-outline</Tooltip>}><i className="typcn typcn-media-pause-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-pause-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-pause</Tooltip>}><i className="typcn typcn-media-pause"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-pause"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-play-outline</Tooltip>}><i className="typcn typcn-media-play-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-play-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-play-revers</Tooltip>}><i className="typcn typcn-media-play-reverse-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-play-reverse-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-play-revers</Tooltip>}><i className="typcn typcn-media-play-reverse"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-play-reverse"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-media-play</Tooltip>}><i className="typcn typcn-media-play"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-play"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-record-outline</Tooltip>}><i className="typcn typcn-media-record-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-record-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-media-record</Tooltip>}><i className="typcn typcn-media-record"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-record"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-rewind-outline</Tooltip>}><i className="typcn typcn-media-rewind-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-rewind-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-media-rewind</Tooltip>}><i className="typcn typcn-media-rewind"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-rewind"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-media-stop-outline</Tooltip>}><i className="typcn typcn-media-stop-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-stop-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-media-stop</Tooltip>}><i className="typcn typcn-media-stop"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-media-stop"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-message-typing</Tooltip>}><i className="typcn typcn-message-typing"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-message-typing"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-message</Tooltip>}><i className="typcn typcn-message"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-message"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-messages</Tooltip>}><i className="typcn typcn-messages"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-messages"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-microphone-outline</Tooltip>}><i className="typcn typcn-microphone-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-microphone-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-microphone</Tooltip>}><i className="typcn typcn-microphone"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-microphone"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-minus-outline</Tooltip>}><i className="typcn typcn-minus-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-minus-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-minus</Tooltip>}><i className="typcn typcn-minus"
                      data-bs-toggle="tooltip" title="typcn typcn-minus"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-mortar-board</Tooltip>}><i className="typcn typcn-mortar-board"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-mortar-board"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-news</Tooltip>}><i className="typcn typcn-news"
                      data-bs-toggle="tooltip" title="typcn typcn-news"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-notes-outline</Tooltip>}><i className="typcn typcn-notes-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-notes-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-notes</Tooltip>}><i className="typcn typcn-notes"
                      data-bs-toggle="tooltip" title="typcn typcn-notes"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-pen</Tooltip>}><i className="typcn typcn-pen"
                      data-bs-toggle="tooltip" title="typcn typcn-pen"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-pencil</Tooltip>}><i className="typcn typcn-pencil"
                      data-bs-toggle="tooltip" title="typcn typcn-pencil"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-phone-outline</Tooltip>}><i className="typcn typcn-phone-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-phone-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-phone</Tooltip>}><i className="typcn typcn-phone"
                      data-bs-toggle="tooltip" title="typcn typcn-phone"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-pi-outline</Tooltip>}><i className="typcn typcn-pi-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-pi-outline"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-pi</Tooltip>}><i className="typcn typcn-pi"
                      data-bs-toggle="tooltip" title="typcn typcn-pi"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-pin-outline</Tooltip>}><i className="typcn typcn-pin-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-pin-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-pin</Tooltip>}><i className="typcn typcn-pin"
                      data-bs-toggle="tooltip" title="typcn typcn-pin"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-pipette</Tooltip>}><i className="typcn typcn-pipette"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-pipette"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-plane-outline</Tooltip>}><i className="typcn typcn-plane-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-plane-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-plane</Tooltip>}><i className="typcn typcn-plane"
                      data-bs-toggle="tooltip" title="typcn typcn-plane"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-plug</Tooltip>}><i className="typcn typcn-plug"
                      data-bs-toggle="tooltip" title="typcn typcn-plug"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-plus-outline</Tooltip>}><i className="typcn typcn-plus-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-plus-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-plus</Tooltip>}><i className="typcn typcn-plus"
                      data-bs-toggle="tooltip" title="typcn typcn-plus"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-point-of-interest</Tooltip>}><i className="typcn typcn-point-of-interest-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-point-of-interest-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-point-of-interest</Tooltip>}><i className="typcn typcn-point-of-interest"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-point-of-interest"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-power-outline</Tooltip>}><i className="typcn typcn-power-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-power-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-power</Tooltip>}><i className="typcn typcn-power"
                      data-bs-toggle="tooltip" title="typcn typcn-power"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-printer</Tooltip>}><i className="typcn typcn-printer"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-printer"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-puzzle-outline</Tooltip>}><i className="typcn typcn-puzzle-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-puzzle-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-puzzle</Tooltip>}><i className="typcn typcn-puzzle"
                      data-bs-toggle="tooltip" title="typcn typcn-puzzle"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-radar-outline</Tooltip>}><i className="typcn typcn-radar-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-radar-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-radar</Tooltip>}><i className="typcn typcn-radar"
                      data-bs-toggle="tooltip" title="typcn typcn-radar"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-refresh-outline</Tooltip>}><i className="typcn typcn-refresh-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-refresh-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-refresh</Tooltip>}><i className="typcn typcn-refresh"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-refresh"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-rss-outline</Tooltip>}><i className="typcn typcn-rss-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-rss-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-rss</Tooltip>}><i className="typcn typcn-rss"
                      data-bs-toggle="tooltip" title="typcn typcn-rss"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-scissors-outline</Tooltip>}><i className="typcn typcn-scissors-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-scissors-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-scissors</Tooltip>}><i className="typcn typcn-scissors"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-scissors"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-shopping-bag</Tooltip>}><i className="typcn typcn-shopping-bag"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-shopping-bag"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-shopping-cart</Tooltip>}><i className="typcn typcn-shopping-cart"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-shopping-cart"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-at-circula</Tooltip>}><i className="typcn typcn-social-at-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-at-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-dribbble-circular</Tooltip>}><i className="typcn typcn-social-dribbble-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-dribbble-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-dribbble</Tooltip>}><i className="typcn typcn-social-dribbble"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-dribbble"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-facebook-circular</Tooltip>}><i className="typcn typcn-social-facebook-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-facebook-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-facebook</Tooltip>}><i className="typcn typcn-social-facebook"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-facebook"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-flickr-circular</Tooltip>}><i className="typcn typcn-social-flickr-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-flickr-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-social-flickr</Tooltip>}><i className="typcn typcn-social-flickr"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-flickr"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-github-circular</Tooltip>}><i className="typcn typcn-social-github-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-github-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-social-github</Tooltip>}><i className="typcn typcn-social-github"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-github"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-google-plus</Tooltip>}><i className="typcn typcn-social-google-plus-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-google-plus-circular"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-google-plus</Tooltip>}><i className="typcn typcn-social-google-plus"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-google-plus"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-instagram-circular</Tooltip>}><i className="typcn typcn-social-instagram-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-instagram-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-instagram</Tooltip>}><i className="typcn typcn-social-instagram"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-instagram"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-last-fm-circular</Tooltip>}><i className="typcn typcn-social-last-fm-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-last-fm-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-social-last-fm</Tooltip>}><i className="typcn typcn-social-last-fm"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-last-fm"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-linkedin-circular</Tooltip>}><i className="typcn typcn-social-linkedin-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-linkedin-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-linkedin</Tooltip>}><i className="typcn typcn-social-linkedin"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-linkedin"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-pinterest-</Tooltip>}><i className="typcn typcn-social-pinterest-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-pinterest-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-pinterest</Tooltip>}><i className="typcn typcn-social-pinterest"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-pinterest"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-skype-outline</Tooltip>}><i className="typcn typcn-social-skype-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-skype-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-social-skype</Tooltip>}><i className="typcn typcn-social-skype"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-skype"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-tumbler-circular</Tooltip>}><i className="typcn typcn-social-tumbler-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-tumbler-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-social-tumbler</Tooltip>}><i className="typcn typcn-social-tumbler"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-tumbler"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-twitter-circular</Tooltip>}><i className="typcn typcn-social-twitter-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-twitter-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-social-twitter</Tooltip>}><i className="typcn typcn-social-twitter"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-twitter"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-vimeo-circircular</Tooltip>}><i className="typcn typcn-social-vimeo-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-vimeo-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-social-vimeo</Tooltip>}><i className="typcn typcn-social-vimeo"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-vimeo"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-social-youtube-circular</Tooltip>}><i className="typcn typcn-social-youtube-circular"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-youtube-circular"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-social-youtube</Tooltip>}><i className="typcn typcn-social-youtube"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-social-youtube"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-sort-alphabetical-outline</Tooltip>}><i className="typcn typcn-sort-alphabetically-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-sort-alphabetically-outline"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-sort-alphabetical</Tooltip>}><i className="typcn typcn-sort-alphabetically"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-sort-alphabetically"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-sort-numerically-outline</Tooltip>}><i className="typcn typcn-sort-numerically-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-sort-numerically-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-sort-numerically</Tooltip>}><i className="typcn typcn-sort-numerically"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-sort-numerically"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-spanner-outline</Tooltip>}><i className="typcn typcn-spanner-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-spanner-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-spanner</Tooltip>}><i className="typcn typcn-spanner"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-spanner"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-spiral</Tooltip>}><i className="typcn typcn-spiral"
                      data-bs-toggle="tooltip" title="typcn typcn-spiral"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-star-full-outline</Tooltip>}><i className="typcn typcn-star-full-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-star-full-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-star-half-outline</Tooltip>}><i className="typcn typcn-star-half-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-star-half-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-star-half</Tooltip>}><i className="typcn typcn-star-half"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-star-half"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-star-outline</Tooltip>}><i className="typcn typcn-star-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-star-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-star</Tooltip>}><i className="typcn typcn-star"
                      data-bs-toggle="tooltip" title="typcn typcn-star"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-starburst-outline</Tooltip>}><i className="typcn typcn-starburst-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-starburst-outline"></i></OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-starburst</Tooltip>}><i className="typcn typcn-starburst"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-starburst"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-stopwatch</Tooltip>}><i className="typcn typcn-stopwatch"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-stopwatch"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip> typcn typcn-support</Tooltip>}><i className="typcn typcn-support"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-support"></i>
                  </OverlayTrigger></li>
                  <li className="icons-list-item">  <OverlayTrigger placement="top" overlay={<Tooltip>typcn typcn-tabs-outline</Tooltip>}><i className="typcn typcn-tabs-outline"
                      data-bs-toggle="tooltip"
                      title="typcn typcn-tabs-outline"></i></OverlayTrigger></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                  <li></li>
                </ul>
              </div>
            </Col>
          </Row>
        </Card.Body>
      </Card>
    </Col>
  </Row>
</Fragment>
);

export default TypiconIcons;
